param(
  [Parameter(Mandatory=$true)]
  [string]$PeerId,

  [Parameter(Mandatory=$false)]
  [string]$SignalUrl = "wss://signal.resnap.tech",

  [Parameter(Mandatory=$false)]
  [int]$MonitorIndex = 1,

  [Parameter(Mandatory=$false)]
  [int]$Width = 1920,

  [Parameter(Mandatory=$false)]
  [int]$Height = 1080,

  [Parameter(Mandatory=$false)]
  [int]$Fps = 60,

  [Parameter(Mandatory=$false)]
  [int]$BitrateKbps = 12000
)

$ErrorActionPreference = "Stop"

$BaseDir = Split-Path -Parent $MyInvocation.MyCommand.Path
$Sender  = Join-Path $BaseDir "webrtc-sendrecv.exe"

# Default GStreamer install path for MSVC x86_64 installer
$GstBin = "C:\gstreamer\1.0\msvc_x86_64\bin"

if (!(Test-Path $Sender)) {
  throw "Sender not found: $Sender"
}
if (!(Test-Path $GstBin)) {
  throw "GStreamer bin not found: $GstBin (is GStreamer installed?)"
}

# Ensure gstreamer binaries in PATH for this process
$env:PATH = "$GstBin;$env:PATH"

# Kill previous sender if any
Get-Process webrtc-sendrecv -ErrorAction SilentlyContinue | Stop-Process -Force -ErrorAction SilentlyContinue

$args = @(
  "--server=$SignalUrl",
  "--our-id=$PeerId",
  "--monitor-index=$MonitorIndex",
  "--show-cursor",
  "--width=$Width",
  "--height=$Height",
  "--fps=$Fps",
  "--bitrate-kbps=$BitrateKbps",
  "--audiosrc=audiotestsrc is-live=true wave=silence"
)

Start-Process -FilePath $Sender -ArgumentList $args -WindowStyle Hidden